package com.bycom.versapro.Utils;

import static com.bycom.versapro.Config.API_URL;
import static com.bycom.versapro.Serializables.Constant.GET_APP_INFO;
import static com.bycom.versapro.Config.PURCHASE_CODE;
import static com.bycom.versapro.Serializables.Constant.appConfig;
import static com.bycom.versapro.Serializables.Constant.gson;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.util.Log;

import com.bycom.versapro.Serializables.AppConfig;
import com.bycom.versapro.Serializables.Constant.AppInfoCallback;
import com.bycom.versapro.Serializables.Constant.JsonCallback;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class NetworkUtil {


    public static void fetchJsonResponse(final String post, final JsonCallback callback) {
        new Thread(() -> {
            try {
                URL url = new URL(API_URL);
                HttpURLConnection urlConnection = (HttpURLConnection) url.openConnection();
                urlConnection.setRequestMethod("POST");

                urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                urlConnection.setDoOutput(true);
                String POST_DATA = post + "&key=" + PURCHASE_CODE;
                byte[] postDataBytes = POST_DATA.getBytes(StandardCharsets.UTF_8);

                OutputStream outputStream = urlConnection.getOutputStream();
                outputStream.write(postDataBytes);
                outputStream.close();

                StringBuilder stringBuilder = new StringBuilder();

                InputStream inputStream;

                int responseCode = urlConnection.getResponseCode();
                if (responseCode == HttpURLConnection.HTTP_OK) {
                    inputStream = urlConnection.getInputStream();
                } else {
                    inputStream = urlConnection.getErrorStream();
                }



                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String line;
                while ((line = reader.readLine()) != null) {
                    stringBuilder.append(line);
                }




                inputStream.close();
                urlConnection.disconnect();

                if(responseCode == HttpURLConnection.HTTP_OK) callback.onSuccess(stringBuilder.toString());
                else callback.onError(stringBuilder.toString());


            } catch (Exception e) {
                callback.onError(e.getMessage());
            }
        }).start();
    }


    public static void fetchAppInfo(final AppInfoCallback callback){

        fetchJsonResponse(GET_APP_INFO, new JsonCallback() {
            @Override
            public void onSuccess(String json) {


                AppConfig appConfig = gson.fromJson(json, AppConfig.class);
                callback.onSuccess(appConfig);
            }
            @Override
            public void onError(String errorMessage) {
                callback.onError(errorMessage);

            }
        });
    }






}
